 ; Ŀ
 ;   Chop - insert a block on a line, cut a chunk out out of the line.     
 ;   Takes the block name and left and right break distances as arguments. 
 ;   Copyright 1994, 2010 by Rocket Software Ltd.                          
 ;   (chop "aa" 1 2)  Don't forget the quotation marks.                    
 ; 
 (DEFUN CHOP (name ldist rdist / scal pa pb ss entt rota xa xb rrr)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Try to load Misps.lsp, which has the ms/ps scaling subroutines.       
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq scal (misps))
  (setq ldist (* ldist scal))
  (setq rdist (* rdist scal))
  (setq pa (getpoint "Insertion point:"))
  (setq pb (osnap pa "Nearest"))
  (if pb (setq pa pb))
  (setq ss (ssget pa))
  (if (and ss (= (cdr (assoc 0 (setq entt (entget (ssname ss 0))))) "LINE"))
      (progn
           (setq rota (angle (cdr (assoc 10 entt)) (cdr (assoc 11 entt))))
           (if (and (> rota (/ pi 2)) (<= rota (* pi 1.5)))
                    (setq rota (+ rota pi)))
           (setq rrota (/ (* 180 rota) pi))
           (setq xa (polar pa rota rdist))
           (setq xb (polar pa rota (- ldist)))
           (command "break" pa "f" xa xb))
      (progn
           (if (/= (type rrota) 'REAL) (setq rrota 0.0))
           (setq rrr (getangle pa (strcat "\nInsertion angle <"
                                          (rtos rrota 2 2) ">: ")))
           (if rrr (setq rrota (/ (* 180 rrr) pi)))))
  (command "insert" name pa scal "" rrota)
 (princ))